# Press kit & brand guidelines

The following press kit provides everything you need when you want to write
about Zensical.

## Table of Contents

1. [Branding essentials](#branding-essentials)
2. [Logo](#logo)
3. [Usage guidelines](#usage-guidelines)
4. [Licensing terms](#license)

## Branding essentials

This section covers our [brand name], [tagline], and [value proposition].
Whether you're writing a news article, creating presentation slides, or
mentioning us in industry reports, this is your go-to reference for accurate
brand representation.

  [brand name]: #brand-name
  [tagline]: #tagline
  [value proposition]: #value-proposition

### Brand name

Our brand name is officially __Zensical__ without an acronym.

### Tagline

Adaptive systems for evolving ideas – Zensical creates scalable Open Source
systems for technical writing that always keep you in the flow.

### Value proposition

Zensical is re-envisioning static site generation (SSG) from first principles –
delivering a next-generation architecture that's built to be the last SSG you'll
ever need. Designed for technical documentation, knowledge management, and
professional blogs, Zensical prioritizes modularity, performance, and
sustainability while dramatically reducing complexity for both creators and
maintainers. Whether you're building a personal blog or scaling to massive
documentation hubs, Zensical provides the flexibility and extensibility to
handle any content challenge.

## Logo

Our logo collection is designed to work across different media formats and
backgrounds. All logos are available as high-resolution PNGs and can be used
according to our [usage guidelines] and [licensing terms] outlined below.

  [usage guidelines]: #usage-guidelines
  [licensing terms]: #license

### Logo files

_You can find our logo collection in the [Logos] folder._

If you need higher resolution files or different file formats for specific use
cases, please reach out to Kathi at contact@zensical.org, and describe your
intended use.

We're happy to provide the appropriate files for your needs.

  [Logos]: Logos

### Clear space

The logo files include built-in padding that defines the minimum clear space.
No other elements should be placed within this padding area.

### Logo placement

- Always position the logo with adequate breathing room
- Preferred positions: top-left or centered
- Maintain the aspect ratio - never stretch or distort

### Acceptable backgrounds

- Place logo on backgrounds that provide sufficient contrast
- Avoid busy or patterned backgrounds
- Use inverted variations on dark backgrounds

## Usage guidelines

These guidelines ensure consistent and appropriate use of our brand assets
across all media. Whether you're a journalist, partner, or researcher, following
these guidelines helps maintain brand integrity.

### Acceptable usage

The Zensical logos and other trademarks are available for the following purposes:

__Press and media coverage:__
- News articles, blog posts, and press releases about Zensical
- Industry reports and whitepapers mentioning our company
- Conference materials when Zensical is a speaker or sponsor
- Podcast graphics when featuring Zensical representatives

__Business communications:__
- Partner announcements and joint press releases
- Event programs where Zensical is participating
- Industry directory listings
- Trade publication advertisements (with approval)

__Educational and research:__
- Academic papers and case studies
- Educational presentations about our industry
- Research reports citing Zensical
- Non-commercial educational materials

### Prohibited uses

- Alter our logos in any way
- Place a logo in such close proximity to other content that it is
  indistinguishable
- Make our logo the most distinctive or prominent feature on your website,
  printed material or other content
- Use our logos in a way that suggests any type of association or partnership
  with Zensical or approval, sponsorship or endorsement by Zensical (unless
  allowed via a license from us)
- Use our logos in a way that is harmful, deceptive, obscene or otherwise
  objectionable to the average person
- Use our logos on websites or other places containing content associated with
  hate speech, pornography, gambling or illegal activities
- Use our logos to, or in connection with, content that disparages us or sullies
  our reputation

## License

Our logos are trademarks of Zensical. Use of these assets is granted only under
the terms outlined in our [usage guidelines] and subject to prior approval for
any uses not explicitly permitted.

Please contact us at contact@zensical.org for permission requests, special use
cases, or access to additional logo formats and versions.

---

*Last updated: October 1, 2025*
